 ; Ŀ
 ;   Rl - relayer entities and block subentities.                          
 ;   Copyright 2000, 2010 by Rocket Software Ltd.                          
 ;   Think of yourself as one of nature's more elaborate subroutines.      
 ; 

 ; Ŀ
 ;   Subroutine Relb - relayer block subentities in the block tables.      
 ; 
 (DEFUN RELB (oldlay gnulay / reww blok enam entt num goon nxt)
  (setq oldlay (strcase oldlay))
  (setq reww t)
  (while (setq blok (tblnext "block" reww))           ; head entity from table
         (setq reww ())
         (grtext -2 (cdr (assoc 2 blok)))
         (setq enam (cdr (assoc -2 blok)))            ; first ename after head
         (while (and enam (setq entt (entget enam)))
                (setq num 0)
                (setq goon t)
                (while (and goon (setq nxt (nth num entt)))
                       (setq num (1+ num))
                       (if (and (= (car nxt) 8)
                                (= (strcase (cdr nxt)) oldlay))
                           (progn
                                (setq goon ())
                                (entmod (subst (cons 8 gnulay) nxt entt)))))
                (setq enam (entnext enam))))
 (princ))
 ; Ŀ
 ;   Relb end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Upblok - relayer attributes in block insertions.           
 ; 
 (DEFUN UPBLOK (oldlay gnulay / ss len num enam entt asoc8)
  (setq oldlay (strcase oldlay))
  (if (setq ss (ssget "X" (list (cons 0 "INSERT") (cons 66 1))))
      (progn
           (setq len (strcat "/" (itoa (sslength ss))))
           (setq num 0)           
           (while (setq enam (ssname ss num))
                  (grtext -2 (strcat (itoa (setq num (1+ num))) len))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq
                                                     enam (entnext enam)))))))
                         (if (and (setq asoc8 (assoc 8 entt))
                                  (= (strcase (cdr asoc8)) oldlay))
                             (entmod (subst (cons 8 gnulay) asoc8 entt)))))))
 (princ))
 ; Ŀ
 ;   Upblok end.                                                           
 ; 

 ; Ŀ
 ;   Rl.                                                                   
 ; 
 (DEFUN C:RL (/ *error* num esav oldlay newlay ss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq oldlay (strcase (getstring "Old layer: ")))
  (setq newlay (strcase (getstring "New layer: ")))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   If the new layer exists, move everything on the old layer to it,      
 ;   otherwise rename the old layer.                                       
 ; 
  (cond ((and (tblsearch "layer" oldlay)
              (null (tblsearch "layer" newlay)))
         (command "rename" "layer" oldlay newlay))
        ((and (tblsearch "layer" oldlay)
              (tblsearch "layer" newlay)
              (setq ss (ssget "X" (list (cons 8 oldlay)))))
         (command "change" ss "" "P" "La" newlay "")))
 ; Ŀ
 ;   Now go through the block tables, change any subentity on the old      
 ;   layer to the new one.                                                 
 ; 
  (relb oldlay newlay)
 ; Ŀ
 ;   Relayer attributes in block insertions - these are not automatically  
 ;   updated when the block tables are changed.                            
 ; 
  (upblok oldlay newlay)
 (princ))